implementation module StdPSt


import	StdBool, StdFile, StdFileSelect, StdFunc, StdTuple
/* RWS ---
from	pointer			import LoadLong
from	fonts			import RealFont
from	OS_utilities	import SysBeep,Secs2Date,Secs2Time
from	quickdraw		import QObscureCursor
import	commondef, windowcursor, processdefaccess, StdFont, StdIOCommon
from	font			import defaultfont, dialogfont, selectfont, fontnames, fontstyles, fontsizes, FontAttsToFont, FontAtts
from	iostate			import PSt, IOSt, 
									accIOToolbox, appIOToolbox, getIOToolbox, setIOToolbox, 
									IOStGetWorld, IOStSetWorld, 
									IOStGetProcessAttributes, IOStSetProcessAttributes, 
									IOStSetDoubleDownDist, DoubleDownDist,
									IOStGetDocumentInterface
from	windowaccess	import IOStGetDialogCursorInfo, IOStSetDialogCursorInfo
*/
// RWS +++
import iostate, commondef, processdefaccess
import StdFont, StdIOCommon, StdTime
import osbeep, osfileselect

import clCrossCall,scheduler

/*	PSt is an environment instance of the class FileEnv (see StdFile).
*/
instance FileEnv (PSt .l .p) where
	accFiles :: !.(*Files -> (.x,*Files)) !*(PSt .l .p) -> (!.x,!*PSt .l .p)
	accFiles accfun pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (x,world)			= accFiles accfun world
		  pState			= {pState & io=IOStSetWorld world io}
		= (x,pState)
	
	appFiles :: !.(*Files -> *Files) !*(PSt .l .p) -> *PSt .l .p
	appFiles appfun pState=:{io}
		# (world,io)		= IOStGetWorld io
		  world				= appFiles appfun world
		  pState			= {pState & io=IOStSetWorld world io}
		= pState


/*	PSt is an environment instance of the class FontEnv (see StdFont).
*/
instance FontEnv (PSt .l .p) where
	openFont :: !FontDef !(PSt .l .p) -> (!(!Bool,!Font),!PSt .l .p)
	openFont fDef pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (bfont,world)		= openFont fDef world
		  pState			= {pState & io=IOStSetWorld world io}
		= (bfont,pState)
	
	openDefaultFont :: !(PSt .l .p) -> (!Font,!PSt .l .p)
	openDefaultFont pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (font,world)		= openDefaultFont world
		  pState			= {pState & io=IOStSetWorld world io}
		= (font,pState)
	
	openDialogFont :: !(PSt .l .p) -> (!Font,!PSt .l .p)
	openDialogFont pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (font,world)		= openDialogFont world
		  pState			= {pState & io=IOStSetWorld world io}
		= (font,pState)
	
	getFontNames :: !(PSt .l .p) -> (![FontName],!PSt .l .p)
	getFontNames pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (names,world)		= getFontNames world
		  pState			= {pState & io=IOStSetWorld world io}
		= (names,pState)
	
	getFontStyles :: !FontName	!(PSt .l .p) -> (![FontStyle],!PSt .l .p)
	getFontStyles fName pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (names,world)		= getFontStyles fName world
		  pState			= {pState & io=IOStSetWorld world io}
		= (names,pState)
	
	getFontSizes :: !Int !Int !FontName	!(PSt .l .p) -> (![FontSize],!PSt .l .p)
	getFontSizes sizeBound1 sizeBound2 fName pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (sizes,world)		= getFontSizes sizeBound1 sizeBound2 fName world
		  pState			= {pState & io=IOStSetWorld world io}
		= (sizes,pState)
	
	getFontCharWidth :: !Char !Font !(PSt .l .p) -> (!Int,!PSt .l .p)
	getFontCharWidth char font pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (width,world)		= getFontCharWidth char font world
		  pState			= {pState & io=IOStSetWorld world io}
		= (width,pState)
	
	getFontCharWidths :: ![Char] !Font !(PSt .l .p) -> (![Int],!PSt .l .p)
	getFontCharWidths chars font pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (widths,world)	= getFontCharWidths chars font world
		  pState			= {pState & io=IOStSetWorld world io}
		= (widths,pState)
	
	getFontStringWidth :: !String !Font !(PSt .l .p) -> (!Int,!PSt .l .p)
	getFontStringWidth string font pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (width,world)		= getFontStringWidth string font world
		  pState			= {pState & io=IOStSetWorld world io}
		= (width,pState)
	
	getFontStringWidths :: ![String] !Font !(PSt .l .p) -> (![Int],!PSt .l .p)
	getFontStringWidths strings font pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (widths,world)	= getFontStringWidths strings font world
		  pState			= {pState & io=IOStSetWorld world io}
		= (widths,pState)
	
	getFontMetrics :: !Font !(PSt .l .p) -> (!FontMetrics,!PSt .l .p)
	getFontMetrics font pState=:{io}
		# (world,io)		= IOStGetWorld io
		  (metrics,world)	= getFontMetrics font world
		  pState			= {pState & io=IOStSetWorld world io}
		= (metrics,pState)


/*	PSt is an environment instance of the class FileSelectEnv (see StdFileSelect).
*/
instance FileSelectEnv (PSt .l .p) where
	selectInputFile :: !(PSt .l .p) -> (!Maybe String,!PSt .l .p)
	selectInputFile pState
		# (ok,name,pState,_)	= OSselectinputfile handleOSEvent pState OSNewToolbox
		= (if ok (Just name) Nothing,pState)
	
	selectOutputFile:: !String !String !(PSt .l .p) -> (!Maybe String,!PSt .l .p)
	selectOutputFile prompt originalName pState
		# (ok,name,pState,_)	= OSselectoutputfile handleOSEvent pState prompt originalName OSNewToolbox
		= (if ok (Just name) Nothing,pState)

//	handleOSEvent turns handleOneEventForDevices into the form required by OSselect(in/out)putfile.
handleOSEvent :: !OSEvent !(PSt .l .p) -> PSt .l .p
handleOSEvent osEvent pState
	= thd3 (handleOneEventForDevices (ScheduleOSEvent osEvent []) pState)


/*	PSt is an environment instance of the class TimeEnv (see StdTime).
*/
instance TimeEnv (PSt .l .p) where
	getBlinkInterval :: !(PSt .l .p) -> (!Int,!PSt .l .p)
	getBlinkInterval pState=:{io}
		# (world,io)		= IOStGetWorld io
		# (blink,world)		= getBlinkInterval world
		# pState			= {pState & io=IOStSetWorld world io}
		= (blink,pState)
	
	getCurrentTime :: !(PSt .l .p) -> (!Time,!PSt .l .p)
	getCurrentTime pState=:{io}
		# (world,io)		= IOStGetWorld io
		# (time,world)		= getCurrentTime world
		# pState			= {pState & io=IOStSetWorld world io}
		= (time,pState)
	
	getCurrentDate :: !(PSt .l .p) -> (!Date,!PSt .l .p)
	getCurrentDate pState=:{io}
		# (world,io)		= IOStGetWorld io
		# (date,world)		= getCurrentDate world
		# pState			= {pState & io=IOStSetWorld world io}
		= (date,pState)


/*	Emit the alert sound.
*/
beep :: !(IOSt .l .p) -> IOSt .l .p
beep ioState = appIOToolbox OSBeep ioState

/* RWS ---
/*	Set the shape of the cursor globally. This shape overrules the local cursor shapes of windows.
*/
setCursor :: !CursorShape !(IOSt .l .p) -> IOSt .l .p
setCursor shape ioState
#	(cInfo,ioState)	= IOStGetDialogCursorInfo ioState
	(cInfo,ioState)	= accIOToolbox (cursorinfoSetGlobalCursor shape cInfo) ioState
	ioState			= IOStSetDialogCursorInfo cInfo ioState
=	ioState


/*	resetCursor undoes the effect of SetCursor.
*/
resetCursor :: !(IOSt .l .p) -> IOSt .l .p
resetCursor ioState
#	(cInfo,ioState)	= IOStGetDialogCursorInfo ioState
	(cInfo,ioState)	= accIOToolbox (cursorinfoResetGlobalCursor cInfo) ioState
	ioState			= IOStSetDialogCursorInfo cInfo ioState
=	ioState


/*	obscureCursor hides the cursor until the mouse is moved.
*/
obscureCursor :: !(IOSt .l .p) -> IOSt .l .p
obscureCursor ioState = appIOToolbox QObscureCursor ioState


/*	setDoubleDownDistance sets the double down distance of the mouse. Negative values are set to zero.
*/
setDoubleDownDistance :: !Int !(IOSt .l .p) -> IOSt .l .p
setDoubleDownDistance newDDDist ioState = IOStSetDoubleDownDist newDDDist ioState

--- RWS */

/*	getDocumentInterface retrieves the DocumentInterface of an interactive process.
*/
getDocumentInterface :: !(IOSt .l .p) -> (!DocumentInterface, !IOSt .l .p)
getDocumentInterface ioState = IOStGetDocumentInterface ioState


/*	Operations on the attributes of an interactive process:
*/
setProcessActivate :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessActivate activateF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessactivate (ProcessActivate activateF) pAtts) ioState

setProcessDeactivate :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessDeactivate deactivateF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessdeactivate (ProcessDeactivate deactivateF) pAtts) ioState

setProcessHelp :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessHelp helpF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocesshelp (ProcessHelp helpF) pAtts) ioState

setProcessAbout :: !(IdFun (PSt .l .p)) !(IOSt .l .p) -> IOSt .l .p
setProcessAbout aboutF ioState
	# (pAtts,ioState)	= IOStGetProcessAttributes ioState
	= IOStSetProcessAttributes (setProcessAttribute isprocessabout (ProcessAbout aboutF) pAtts) ioState

setProcessAttribute :: !(Cond (ProcessAttribute .ps)) !(ProcessAttribute .ps) ![ProcessAttribute .ps] -> [ProcessAttribute .ps]
setProcessAttribute cond pAtt` [pAtt:pAtts]
	| cond pAtt
		= [pAtt`:pAtts]
		= [pAtt :setProcessAttribute cond pAtt` pAtts]
setProcessAttribute _ pAtt` _
		= [pAtt`]


//	Coercing PSt component operations to PSt operations.

appListPIO :: ![.IdFun (IOSt .l .p)] !(PSt .l .p) -> PSt .l .p
appListPIO fs pState=:{io} = {pState & io=StrictSeq fs io}

appListPLoc :: ![.IdFun .l] !(PSt .l .p) -> PSt .l .p
appListPLoc fs pState=:{ls} = {pState & ls=StrictSeq fs ls}

appListPPub :: ![.IdFun .p] !(PSt .l .p) -> PSt .l .p
appListPPub fs pState=:{ps} = {pState & ps=StrictSeq fs ps}

appPIO :: !.(IdFun (IOSt .l .p)) !(PSt .l .p) -> PSt .l .p
appPIO f pState=:{io} = {pState & io=f io}

appPLoc :: !.(IdFun .l) !(PSt .l .p) -> PSt .l .p
appPLoc f pState=:{ls} = {pState & ls=f ls}

appPPub :: !.(IdFun .p) !(PSt .l .p) -> PSt .l .p
appPPub f pState=:{ps} = {pState & ps=f ps}


//	Accessing PSt component operations.

accListPIO :: ![.St (IOSt .l .p) .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPIO fs pState=:{io}
	# (xs,io) = StrictSeqList fs io
	= (xs,{pState & io=io})

accListPLoc :: ![.St .l .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPLoc fs pState=:{ls}
	# (xs,ls) = StrictSeqList fs ls
	= (xs,{pState & ls=ls})

accListPPub :: ![.St .p .x] !(PSt .l .p) -> (![.x],!PSt .l .p)
accListPPub fs pState=:{ps}
	# (xs,ps) = StrictSeqList fs ps
	= (xs,{pState & ps=ps})

accPIO :: !.(St (IOSt .l .p) .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPIO f pState=:{io}
	# (x,io) = f io
	= (x,{pState & io=io})

accPLoc :: !.(St .l .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPLoc f pState=:{ls}
	# (x,ls) = f ls
	= (x,{pState & ls=ls})

accPPub :: !.(St .p .x) !(PSt .l .p) -> (!.x,!PSt .l .p)
accPPub f pState=:{ps}
	# (x,ps) = f ps
	= (x,{pState & ps=ps})
